﻿
-- --------------------------------------------------
-- Creating all tables for Business app
-- --------------------------------------------------

-- Creating table 'BA_App'
CREATE TABLE [dbo].[BA_App] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(128)  NOT NULL,
    [SiteTemplatePath] nvarchar(256)  NOT NULL
);
GO

-- Creating table 'BA_Instance'
CREATE TABLE [dbo].[BA_Instance] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
    [Url] nvarchar(max)  NOT NULL,
    [AppId] int  NOT NULL
);
GO

-- Creating table 'BA_SiteType'
CREATE TABLE [dbo].[BA_SiteType] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [InstanceId] int  NOT NULL,
    [SiteTemplatePath] nvarchar(256)  NOT NULL,
    [StartPhaseId] int  NOT NULL,
    [MetadataFormDesign] nvarchar(max)  NULL,
    [ApprovalEnabled] bit  NOT NULL
);
GO

-- Creating table 'BA_Principal'
CREATE TABLE [dbo].[BA_Principal] (
    [PrincipalId] int  NOT NULL
);
GO

-- Creating table 'BA_Metadata'
CREATE TABLE [dbo].[BA_Metadata] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Value] nvarchar(max)  NOT NULL,
    [ValueDecimal] decimal(18,0)  NULL,
    [ValueDate] datetime  NULL,
    [MetadataDefinition_Id] int  NOT NULL,
    [Site_Id] int  NOT NULL
);
GO

-- Creating table 'BA_MetadataDefinition'
CREATE TABLE [dbo].[BA_MetadataDefinition] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
    [Definition] nvarchar(max)  NOT NULL,
    [Type] nvarchar(125)  NOT NULL,
    [Required] bit  NOT NULL,
    [Instance_Id] int  NULL
);
GO

-- Creating table 'BA_Action'
CREATE TABLE [dbo].[BA_Action] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [SiteType_Id] int  NOT NULL
);
GO

-- Creating table 'BA_Role'
CREATE TABLE [dbo].[BA_Role] (
    [RepositoryConfigRoleId] int  NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
    [PermissionMask] bigint  NOT NULL,
    [AllowMultiple] bit  NOT NULL,
    [AllowPersons] bit  NOT NULL,
    [AllowGroups] bit  NOT NULL,
    [CanEditMetadata] bit  NOT NULL,
    [CanAssignRoles] bit  NOT NULL,
    [SortOrder] int  NOT NULL,
    [SiteType_Id] int  NOT NULL
);
GO

-- Creating table 'BA_Phase'
CREATE TABLE [dbo].[BA_Phase] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [SiteTypeId] int  NOT NULL,
    [BA_PhaseBA_Phase_BA_Phase1_Id] int  NULL
);
GO

-- Creating table 'BA_Site'
CREATE TABLE [dbo].[BA_Site] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Url] nvarchar(max)  NOT NULL,
    [SharePointWebId] uniqueidentifier  NOT NULL,
    [Status] int  NOT NULL,
    [StatusLastChanged] datetime  NOT NULL,
    [SiteType_Id] int  NOT NULL,
    [CurrentPhase_Id] int  NOT NULL,
    [StatusLastChangedBy_PrincipalId] int  NOT NULL
);
GO

-- Creating table 'BA_SiteRole'
CREATE TABLE [dbo].[BA_SiteRole] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Site_Id] int  NOT NULL,
    [Role_RepositoryConfigRoleId] int  NOT NULL
);
GO

-- Creating table 'BA_SiteHistory'
CREATE TABLE [dbo].[BA_SiteHistory] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [StatusSetTo] int  NOT NULL,
    [Comment] nvarchar(max)  NOT NULL,
    [Created] datetime  NOT NULL,
    [Site_Id] int  NOT NULL,
    [CreatedBy_PrincipalId] int  NOT NULL
);
GO

-- Creating table 'BA_InstancePrincipal'
CREATE TABLE [dbo].[BA_InstancePrincipal] (
    [AdministratorForInstances_Id] int  NOT NULL,
    [Administrators_PrincipalId] int  NOT NULL
);
GO

-- Creating table 'BA_SiteTypeMetadataDefinition'
CREATE TABLE [dbo].[BA_SiteTypeMetadataDefinition] (
    [SiteTypes_Id] int  NOT NULL,
    [MetadataDefinitions_Id] int  NOT NULL
);
GO

-- Creating table 'BA_PhaseAction'
CREATE TABLE [dbo].[BA_PhaseAction] (
    [PhaseAction_BA_Action_Id] int  NOT NULL,
    [PreferedActions_Id] int  NOT NULL
);
GO

-- Creating table 'BA_PrincipalBA_Site'
CREATE TABLE [dbo].[BA_PrincipalBA_Site] (
    [FavouriteBy_PrincipalId] int  NOT NULL,
    [FavouriteSites_Id] int  NOT NULL
);
GO

-- Creating table 'BA_SiteRoleBA_Principal'
CREATE TABLE [dbo].[BA_SiteRoleBA_Principal] (
    [BA_SiteRoleBA_Principal_BA_Principal_Id] int  NOT NULL,
    [Principals_PrincipalId] int  NOT NULL
);
GO

-- Creating table 'BA_SiteTypeBA_Principal'
CREATE TABLE [dbo].[BA_SiteTypeBA_Principal] (
    [SiteTypesToApprove_Id] int  NOT NULL,
    [Approvers_PrincipalId] int  NOT NULL
);
GO

-- Creating table 'BA_InstanceBA_Principal'
CREATE TABLE [dbo].[BA_InstanceBA_Principal] (
    [SiteCreatorForInstances_Id] int  NOT NULL,
    [SiteCreators_PrincipalId] int  NOT NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'BA_App'
ALTER TABLE [dbo].[BA_App]
ADD CONSTRAINT [PK_BA_App]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'BA_Instance'
ALTER TABLE [dbo].[BA_Instance]
ADD CONSTRAINT [PK_BA_Instance]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'BA_SiteType'
ALTER TABLE [dbo].[BA_SiteType]
ADD CONSTRAINT [PK_BA_SiteType]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [PrincipalId] in table 'BA_Principal'
ALTER TABLE [dbo].[BA_Principal]
ADD CONSTRAINT [PK_BA_Principal]
    PRIMARY KEY CLUSTERED ([PrincipalId] ASC);
GO

-- Creating primary key on [Id] in table 'BA_Metadata'
ALTER TABLE [dbo].[BA_Metadata]
ADD CONSTRAINT [PK_BA_Metadata]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'BA_MetadataDefinition'
ALTER TABLE [dbo].[BA_MetadataDefinition]
ADD CONSTRAINT [PK_BA_MetadataDefinition]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'BA_Action'
ALTER TABLE [dbo].[BA_Action]
ADD CONSTRAINT [PK_BA_Action]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [RepositoryConfigRoleId] in table 'BA_Role'
ALTER TABLE [dbo].[BA_Role]
ADD CONSTRAINT [PK_BA_Role]
    PRIMARY KEY CLUSTERED ([RepositoryConfigRoleId] ASC);
GO

-- Creating primary key on [Id] in table 'BA_Phase'
ALTER TABLE [dbo].[BA_Phase]
ADD CONSTRAINT [PK_BA_Phase]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'BA_Site'
ALTER TABLE [dbo].[BA_Site]
ADD CONSTRAINT [PK_BA_Site]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'BA_SiteRole'
ALTER TABLE [dbo].[BA_SiteRole]
ADD CONSTRAINT [PK_BA_SiteRole]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'BA_SiteHistory'
ALTER TABLE [dbo].[BA_SiteHistory]
ADD CONSTRAINT [PK_BA_SiteHistory]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [AdministratorForInstances_Id], [Administrators_PrincipalId] in table 'BA_InstancePrincipal'
ALTER TABLE [dbo].[BA_InstancePrincipal]
ADD CONSTRAINT [PK_BA_InstancePrincipal]
    PRIMARY KEY CLUSTERED ([AdministratorForInstances_Id], [Administrators_PrincipalId] ASC);
GO

-- Creating primary key on [SiteTypes_Id], [MetadataDefinitions_Id] in table 'BA_SiteTypeMetadataDefinition'
ALTER TABLE [dbo].[BA_SiteTypeMetadataDefinition]
ADD CONSTRAINT [PK_BA_SiteTypeMetadataDefinition]
    PRIMARY KEY CLUSTERED ([SiteTypes_Id], [MetadataDefinitions_Id] ASC);
GO

-- Creating primary key on [PhaseAction_BA_Action_Id], [PreferedActions_Id] in table 'BA_PhaseAction'
ALTER TABLE [dbo].[BA_PhaseAction]
ADD CONSTRAINT [PK_BA_PhaseAction]
    PRIMARY KEY CLUSTERED ([PhaseAction_BA_Action_Id], [PreferedActions_Id] ASC);
GO

-- Creating primary key on [FavouriteBy_PrincipalId], [FavouriteSites_Id] in table 'BA_PrincipalBA_Site'
ALTER TABLE [dbo].[BA_PrincipalBA_Site]
ADD CONSTRAINT [PK_BA_PrincipalBA_Site]
    PRIMARY KEY CLUSTERED ([FavouriteBy_PrincipalId], [FavouriteSites_Id] ASC);
GO

-- Creating primary key on [BA_SiteRoleBA_Principal_BA_Principal_Id], [Principals_PrincipalId] in table 'BA_SiteRoleBA_Principal'
ALTER TABLE [dbo].[BA_SiteRoleBA_Principal]
ADD CONSTRAINT [PK_BA_SiteRoleBA_Principal]
    PRIMARY KEY CLUSTERED ([BA_SiteRoleBA_Principal_BA_Principal_Id], [Principals_PrincipalId] ASC);
GO

-- Creating primary key on [SiteTypesToApprove_Id], [Approvers_PrincipalId] in table 'BA_SiteTypeBA_Principal'
ALTER TABLE [dbo].[BA_SiteTypeBA_Principal]
ADD CONSTRAINT [PK_BA_SiteTypeBA_Principal]
    PRIMARY KEY CLUSTERED ([SiteTypesToApprove_Id], [Approvers_PrincipalId] ASC);
GO

-- Creating primary key on [SiteCreatorForInstances_Id], [SiteCreators_PrincipalId] in table 'BA_InstanceBA_Principal'
ALTER TABLE [dbo].[BA_InstanceBA_Principal]
ADD CONSTRAINT [PK_BA_InstanceBA_Principal]
    PRIMARY KEY CLUSTERED ([SiteCreatorForInstances_Id], [SiteCreators_PrincipalId] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [AppId] in table 'BA_Instance'
ALTER TABLE [dbo].[BA_Instance]
ADD CONSTRAINT [FK_AppInstance]
    FOREIGN KEY ([AppId])
    REFERENCES [dbo].[BA_App]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_AppInstance'
CREATE INDEX [IX_FK_AppInstance]
ON [dbo].[BA_Instance]
    ([AppId]);
GO

-- Creating foreign key on [InstanceId] in table 'BA_SiteType'
ALTER TABLE [dbo].[BA_SiteType]
ADD CONSTRAINT [FK_InstanceSiteType]
    FOREIGN KEY ([InstanceId])
    REFERENCES [dbo].[BA_Instance]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceSiteType'
CREATE INDEX [IX_FK_InstanceSiteType]
ON [dbo].[BA_SiteType]
    ([InstanceId]);
GO

-- Creating foreign key on [AdministratorForInstances_Id] in table 'BA_InstancePrincipal'
ALTER TABLE [dbo].[BA_InstancePrincipal]
ADD CONSTRAINT [FK_InstanceUser_Instance]
    FOREIGN KEY ([AdministratorForInstances_Id])
    REFERENCES [dbo].[BA_Instance]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Administrators_PrincipalId] in table 'BA_InstancePrincipal'
ALTER TABLE [dbo].[BA_InstancePrincipal]
ADD CONSTRAINT [FK_InstanceUser_User]
    FOREIGN KEY ([Administrators_PrincipalId])
    REFERENCES [dbo].[BA_Principal]
        ([PrincipalId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceUser_User'
CREATE INDEX [IX_FK_InstanceUser_User]
ON [dbo].[BA_InstancePrincipal]
    ([Administrators_PrincipalId]);
GO

-- Creating foreign key on [Instance_Id] in table 'BA_MetadataDefinition'
ALTER TABLE [dbo].[BA_MetadataDefinition]
ADD CONSTRAINT [FK_InstanceMetadataDefinition]
    FOREIGN KEY ([Instance_Id])
    REFERENCES [dbo].[BA_Instance]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceMetadataDefinition'
CREATE INDEX [IX_FK_InstanceMetadataDefinition]
ON [dbo].[BA_MetadataDefinition]
    ([Instance_Id]);
GO

-- Creating foreign key on [SiteTypes_Id] in table 'BA_SiteTypeMetadataDefinition'
ALTER TABLE [dbo].[BA_SiteTypeMetadataDefinition]
ADD CONSTRAINT [FK_SiteTypeMetadataDefinition_SiteType]
    FOREIGN KEY ([SiteTypes_Id])
    REFERENCES [dbo].[BA_SiteType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [MetadataDefinitions_Id] in table 'BA_SiteTypeMetadataDefinition'
ALTER TABLE [dbo].[BA_SiteTypeMetadataDefinition]
ADD CONSTRAINT [FK_SiteTypeMetadataDefinition_MetadataDefinition]
    FOREIGN KEY ([MetadataDefinitions_Id])
    REFERENCES [dbo].[BA_MetadataDefinition]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_SiteTypeMetadataDefinition_MetadataDefinition'
CREATE INDEX [IX_FK_SiteTypeMetadataDefinition_MetadataDefinition]
ON [dbo].[BA_SiteTypeMetadataDefinition]
    ([MetadataDefinitions_Id]);
GO

-- Creating foreign key on [MetadataDefinition_Id] in table 'BA_Metadata'
ALTER TABLE [dbo].[BA_Metadata]
ADD CONSTRAINT [FK_MetadataMetadataDefinition]
    FOREIGN KEY ([MetadataDefinition_Id])
    REFERENCES [dbo].[BA_MetadataDefinition]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_MetadataMetadataDefinition'
CREATE INDEX [IX_FK_MetadataMetadataDefinition]
ON [dbo].[BA_Metadata]
    ([MetadataDefinition_Id]);
GO

-- Creating foreign key on [SiteType_Id] in table 'BA_Site'
ALTER TABLE [dbo].[BA_Site]
ADD CONSTRAINT [FK_SiteSiteType]
    FOREIGN KEY ([SiteType_Id])
    REFERENCES [dbo].[BA_SiteType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_SiteSiteType'
CREATE INDEX [IX_FK_SiteSiteType]
ON [dbo].[BA_Site]
    ([SiteType_Id]);
GO

-- Creating foreign key on [SiteType_Id] in table 'BA_Action'
ALTER TABLE [dbo].[BA_Action]
ADD CONSTRAINT [FK_SiteTypeAction]
    FOREIGN KEY ([SiteType_Id])
    REFERENCES [dbo].[BA_SiteType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_SiteTypeAction'
CREATE INDEX [IX_FK_SiteTypeAction]
ON [dbo].[BA_Action]
    ([SiteType_Id]);
GO

-- Creating foreign key on [SiteTypeId] in table 'BA_Phase'
ALTER TABLE [dbo].[BA_Phase]
ADD CONSTRAINT [FK_SiteTypePhase]
    FOREIGN KEY ([SiteTypeId])
    REFERENCES [dbo].[BA_SiteType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_SiteTypePhase'
CREATE INDEX [IX_FK_SiteTypePhase]
ON [dbo].[BA_Phase]
    ([SiteTypeId]);
GO

-- Creating foreign key on [PhaseAction_BA_Action_Id] in table 'BA_PhaseAction'
ALTER TABLE [dbo].[BA_PhaseAction]
ADD CONSTRAINT [FK_PhaseAction_BA_Phase]
    FOREIGN KEY ([PhaseAction_BA_Action_Id])
    REFERENCES [dbo].[BA_Phase]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [PreferedActions_Id] in table 'BA_PhaseAction'
ALTER TABLE [dbo].[BA_PhaseAction]
ADD CONSTRAINT [FK_PhaseAction_BA_Action]
    FOREIGN KEY ([PreferedActions_Id])
    REFERENCES [dbo].[BA_Action]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PhaseAction_BA_Action'
CREATE INDEX [IX_FK_PhaseAction_BA_Action]
ON [dbo].[BA_PhaseAction]
    ([PreferedActions_Id]);
GO

-- Creating foreign key on [BA_PhaseBA_Phase_BA_Phase1_Id] in table 'BA_Phase'
ALTER TABLE [dbo].[BA_Phase]
ADD CONSTRAINT [FK_BA_PhaseBA_Phase]
    FOREIGN KEY ([BA_PhaseBA_Phase_BA_Phase1_Id])
    REFERENCES [dbo].[BA_Phase]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_PhaseBA_Phase'
CREATE INDEX [IX_FK_BA_PhaseBA_Phase]
ON [dbo].[BA_Phase]
    ([BA_PhaseBA_Phase_BA_Phase1_Id]);
GO

-- Creating foreign key on [Site_Id] in table 'BA_Metadata'
ALTER TABLE [dbo].[BA_Metadata]
ADD CONSTRAINT [FK_SiteMetadata]
    FOREIGN KEY ([Site_Id])
    REFERENCES [dbo].[BA_Site]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_SiteMetadata'
CREATE INDEX [IX_FK_SiteMetadata]
ON [dbo].[BA_Metadata]
    ([Site_Id]);
GO

-- Creating foreign key on [CurrentPhase_Id] in table 'BA_Site'
ALTER TABLE [dbo].[BA_Site]
ADD CONSTRAINT [FK_SitePhase]
    FOREIGN KEY ([CurrentPhase_Id])
    REFERENCES [dbo].[BA_Phase]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_SitePhase'
CREATE INDEX [IX_FK_SitePhase]
ON [dbo].[BA_Site]
    ([CurrentPhase_Id]);
GO

-- Creating foreign key on [SiteType_Id] in table 'BA_Role'
ALTER TABLE [dbo].[BA_Role]
ADD CONSTRAINT [FK_SiteTypeRole]
    FOREIGN KEY ([SiteType_Id])
    REFERENCES [dbo].[BA_SiteType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_SiteTypeRole'
CREATE INDEX [IX_FK_SiteTypeRole]
ON [dbo].[BA_Role]
    ([SiteType_Id]);
GO

-- Creating foreign key on [FavouriteBy_PrincipalId] in table 'BA_PrincipalBA_Site'
ALTER TABLE [dbo].[BA_PrincipalBA_Site]
ADD CONSTRAINT [FK_BA_PrincipalBA_Site_BA_Principal]
    FOREIGN KEY ([FavouriteBy_PrincipalId])
    REFERENCES [dbo].[BA_Principal]
        ([PrincipalId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [FavouriteSites_Id] in table 'BA_PrincipalBA_Site'
ALTER TABLE [dbo].[BA_PrincipalBA_Site]
ADD CONSTRAINT [FK_BA_PrincipalBA_Site_BA_Site]
    FOREIGN KEY ([FavouriteSites_Id])
    REFERENCES [dbo].[BA_Site]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_PrincipalBA_Site_BA_Site'
CREATE INDEX [IX_FK_BA_PrincipalBA_Site_BA_Site]
ON [dbo].[BA_PrincipalBA_Site]
    ([FavouriteSites_Id]);
GO

-- Creating foreign key on [Site_Id] in table 'BA_SiteRole'
ALTER TABLE [dbo].[BA_SiteRole]
ADD CONSTRAINT [FK_BA_SiteRoleBA_Site]
    FOREIGN KEY ([Site_Id])
    REFERENCES [dbo].[BA_Site]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_SiteRoleBA_Site'
CREATE INDEX [IX_FK_BA_SiteRoleBA_Site]
ON [dbo].[BA_SiteRole]
    ([Site_Id]);
GO

-- Creating foreign key on [BA_SiteRoleBA_Principal_BA_Principal_Id] in table 'BA_SiteRoleBA_Principal'
ALTER TABLE [dbo].[BA_SiteRoleBA_Principal]
ADD CONSTRAINT [FK_BA_SiteRoleBA_Principal_BA_SiteRole]
    FOREIGN KEY ([BA_SiteRoleBA_Principal_BA_Principal_Id])
    REFERENCES [dbo].[BA_SiteRole]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Principals_PrincipalId] in table 'BA_SiteRoleBA_Principal'
ALTER TABLE [dbo].[BA_SiteRoleBA_Principal]
ADD CONSTRAINT [FK_BA_SiteRoleBA_Principal_BA_Principal]
    FOREIGN KEY ([Principals_PrincipalId])
    REFERENCES [dbo].[BA_Principal]
        ([PrincipalId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_SiteRoleBA_Principal_BA_Principal'
CREATE INDEX [IX_FK_BA_SiteRoleBA_Principal_BA_Principal]
ON [dbo].[BA_SiteRoleBA_Principal]
    ([Principals_PrincipalId]);
GO

-- Creating foreign key on [Role_RepositoryConfigRoleId] in table 'BA_SiteRole'
ALTER TABLE [dbo].[BA_SiteRole]
ADD CONSTRAINT [FK_BA_SiteRoleBA_Role]
    FOREIGN KEY ([Role_RepositoryConfigRoleId])
    REFERENCES [dbo].[BA_Role]
        ([RepositoryConfigRoleId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_SiteRoleBA_Role'
CREATE INDEX [IX_FK_BA_SiteRoleBA_Role]
ON [dbo].[BA_SiteRole]
    ([Role_RepositoryConfigRoleId]);
GO

-- Creating foreign key on [StatusLastChangedBy_PrincipalId] in table 'BA_Site'
ALTER TABLE [dbo].[BA_Site]
ADD CONSTRAINT [FK_BA_SiteBA_Principal]
    FOREIGN KEY ([StatusLastChangedBy_PrincipalId])
    REFERENCES [dbo].[BA_Principal]
        ([PrincipalId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_SiteBA_Principal'
CREATE INDEX [IX_FK_BA_SiteBA_Principal]
ON [dbo].[BA_Site]
    ([StatusLastChangedBy_PrincipalId]);
GO

-- Creating foreign key on [Site_Id] in table 'BA_SiteHistory'
ALTER TABLE [dbo].[BA_SiteHistory]
ADD CONSTRAINT [FK_BA_SiteBA_SiteHistory]
    FOREIGN KEY ([Site_Id])
    REFERENCES [dbo].[BA_Site]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_SiteBA_SiteHistory'
CREATE INDEX [IX_FK_BA_SiteBA_SiteHistory]
ON [dbo].[BA_SiteHistory]
    ([Site_Id]);
GO

-- Creating foreign key on [CreatedBy_PrincipalId] in table 'BA_SiteHistory'
ALTER TABLE [dbo].[BA_SiteHistory]
ADD CONSTRAINT [FK_BA_SiteHistoryBA_Principal]
    FOREIGN KEY ([CreatedBy_PrincipalId])
    REFERENCES [dbo].[BA_Principal]
        ([PrincipalId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_SiteHistoryBA_Principal'
CREATE INDEX [IX_FK_BA_SiteHistoryBA_Principal]
ON [dbo].[BA_SiteHistory]
    ([CreatedBy_PrincipalId]);
GO

-- Creating foreign key on [SiteTypesToApprove_Id] in table 'BA_SiteTypeBA_Principal'
ALTER TABLE [dbo].[BA_SiteTypeBA_Principal]
ADD CONSTRAINT [FK_BA_SiteTypeBA_Principal_BA_SiteType]
    FOREIGN KEY ([SiteTypesToApprove_Id])
    REFERENCES [dbo].[BA_SiteType]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Approvers_PrincipalId] in table 'BA_SiteTypeBA_Principal'
ALTER TABLE [dbo].[BA_SiteTypeBA_Principal]
ADD CONSTRAINT [FK_BA_SiteTypeBA_Principal_BA_Principal]
    FOREIGN KEY ([Approvers_PrincipalId])
    REFERENCES [dbo].[BA_Principal]
        ([PrincipalId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_SiteTypeBA_Principal_BA_Principal'
CREATE INDEX [IX_FK_BA_SiteTypeBA_Principal_BA_Principal]
ON [dbo].[BA_SiteTypeBA_Principal]
    ([Approvers_PrincipalId]);
GO

-- Creating foreign key on [SiteCreatorForInstances_Id] in table 'BA_InstanceBA_Principal'
ALTER TABLE [dbo].[BA_InstanceBA_Principal]
ADD CONSTRAINT [FK_BA_InstanceBA_Principal_BA_Instance]
    FOREIGN KEY ([SiteCreatorForInstances_Id])
    REFERENCES [dbo].[BA_Instance]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [SiteCreators_PrincipalId] in table 'BA_InstanceBA_Principal'
ALTER TABLE [dbo].[BA_InstanceBA_Principal]
ADD CONSTRAINT [FK_BA_InstanceBA_Principal_BA_Principal]
    FOREIGN KEY ([SiteCreators_PrincipalId])
    REFERENCES [dbo].[BA_Principal]
        ([PrincipalId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_BA_InstanceBA_Principal_BA_Principal'
CREATE INDEX [IX_FK_BA_InstanceBA_Principal_BA_Principal]
ON [dbo].[BA_InstanceBA_Principal]
    ([SiteCreators_PrincipalId]);
GO

-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------